<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Roadway Design Milling Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis návrhu koridoru Frézování</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis návrhu koridoru Frézování</h2>
                                <p lang="en">
                                    Report Created:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Time:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <hr/>
                            <!-- Project Data -->
                            <xsl:for-each select="RoadwayDesignProject">
                                <!-- Milling Station Data -->
                                <table class="margin" cellpadding="2" cellspacing="4" width="90%">
                                    <thead>
                                        <tr>
                                            <th class="underline" align="right" lang="en">Staničení</th>
                                            <th class="underline" align="right" lang="en">Levý odstup/<br/>Z</th>
                                            <th class="underline" align="right" lang="en">Pravý odstup/<br/>Z</th>
                                            <th class="underline" align="right" lang="en">Promítnutá plocha</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <xsl:for-each select="MillingStations/MillingStation/MillingComponents">
                                            <xsl:for-each select="MillingComponent">
                                                <tr>
                                                    <td align="right" valign="top">
                                                        <xsl:choose>
                                                            <xsl:when test="position() = 1">
                                                                <xsl:value-of select="cif:stationFormat(number(../../@externalStation), string(../../@externalStationName))"/>
                                                            </xsl:when>
                                                            <xsl:otherwise>&#xa0;</xsl:otherwise>
                                                        </xsl:choose>
                                                    </td>
                                                    <td align="right" valign="top">
                                                        <xsl:for-each select="OffsetValues">
                                                            <xsl:value-of select="cif:distanceFormat(number(@leftOffset))"/><br/>
                                                            <xsl:value-of select="cif:ordinateFormat(number(@leftElevation))"/><br/>
                                                        </xsl:for-each>
                                                        <br/>
                                                    </td>
                                                    <td align="right" valign="top">
                                                        <xsl:for-each select="OffsetValues">
                                                            <xsl:value-of select="cif:distanceFormat(number(@rightOffset))"/><br/>
                                                            <xsl:value-of select="cif:ordinateFormat(number(@rightElevation))"/><br/>
                                                        </xsl:for-each>
                                                        <br/>
                                                    </td>
                                                    <td align="right" valign="top">
                                                        <xsl:choose>
                                                            <xsl:when test="position() = last()">
                                                                <xsl:value-of select="cif:areaFormat(number(sum(..//@planarArea)) )"/>
                                                            </xsl:when>
                                                            <xsl:otherwise>&#xa0;</xsl:otherwise>
                                                        </xsl:choose>
                                                    </td>
                                                </tr>
                                            </xsl:for-each>
                                        </xsl:for-each>
                                        <tr><th colspan="4"><hr/></th></tr>
                                        <tr>
                                            <th align="right" colspan="3">Plocha celkem:</th>
                                            <td align="right">
                                                <xsl:value-of select="cif:areaFormat(number(sum(//MillingComponent/@planarArea)))"/>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Před vytvářením výpisu musíte mít nejméně jednu komponentu frézování/balení s nastavením frézování.&#xa0; 
                Tato komponenta bude představovat frézování.&#xa0; Také by měl být proveden výpočet koridoru pomocí Zpracovat Vše.                
            </p>
            <p class="normal1" lang="en">
                Výpis vytvoříte příkazem <em>Modelář &gt; Návrh cesty &gt; Nástroje&gt; Výpis frézování.</em>.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2009 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
